(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     35316,        924]
NotebookOptionsPosition[     31826,        860]
NotebookOutlinePosition[     32303,        879]
CellTagsIndexPosition[     32260,        876]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "PrSAT`"}]], "Input",
 CellChangeTimes->{{3.8068651772092857`*^9, 3.806865181679206*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"c51b649d-7383-4c70-81e8-943f214f9944"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s just consider a pair {\[DoubleStruckCapitalH],\
\[DoubleStruckCapitalE]}, and the following UR-prior ",
 StyleBox["m", "Input"],
 ", such that the Likelihood Ratio in ",
 StyleBox["m", "Input"],
 " for {\[DoubleStruckCapitalH],\[DoubleStruckCapitalE]} is 8, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["LR", 
    StyleBox["m", "Input",
     FontSlant->"Plain"]], TraditionalForm]],ExpressionUUID->
  "1b3c7324-6914-4367-91ec-fa9a7ee7a8bc"],
 "[\[DoubleStruckCapitalH],\[DoubleStruckCapitalE]] = 8. (We also represent ",
 StyleBox["m", "Input"],
 "* algebraically)."
}], "Text",
 CellChangeTimes->{{3.806923299292807*^9, 3.8069233023114147`*^9}, {
  3.806930648200594*^9, 3.806930657414904*^9}, {3.806930716104648*^9, 
  3.806930748637622*^9}, {3.806930992223275*^9, 3.806930995574971*^9}, {
  3.808650757511207*^9, 3.808650769006208*^9}, {3.808650799109136*^9, 
  3.808650854344198*^9}, {3.808651706491733*^9, 3.808651709403162*^9}, {
  3.808651839470251*^9, 
  3.808651868622755*^9}},ExpressionUUID->"a99b4e68-8620-4696-9173-\
f22fe6bbfd22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", GridBox[{
    {"\[DoubleStruckCapitalH]", "\[DoubleStruckCapitalE]", "m", 
     SuperscriptBox["m", "*"]},
    {"T", "T", 
     FractionBox["1", "4"], "d"},
    {"T", "F", 
     FractionBox["1", "4"], "e"},
    {"F", "T", 
     FractionBox["1", "32"], "f"},
    {"F", "F", 
     FractionBox["15", "32"], 
     RowBox[{"1", "-", 
      RowBox[{"(", 
       RowBox[{"d", "+", "e", "+", "f"}], ")"}]}]}
   }]}]], "Input",
 CellChangeTimes->{{3.806923318674481*^9, 3.8069233813565598`*^9}, {
  3.806930658877268*^9, 3.8069307080003357`*^9}, {3.8086518190609827`*^9, 
  3.8086518232398243`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"716b237e-d443-423a-a79b-a4a8f48d335c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[DoubleStruckCapitalH]", ",", "\[DoubleStruckCapitalE]", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[DoubleStruckCapitalE]", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["\[DoubleStruckA]", "2"], ",", 
            SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
         RowBox[{"\[DoubleStruckCapitalH]", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["\[DoubleStruckA]", "3"], ",", 
            SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
         RowBox[{"\[CapitalOmega]", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["\[DoubleStruckA]", "1"], ",", 
            SubscriptBox["\[DoubleStruckA]", "2"], ",", 
            SubscriptBox["\[DoubleStruckA]", "3"], ",", 
            SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "1"], "\[Rule]", 
          FractionBox["15", "32"]}], ",", 
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "2"], "\[Rule]", 
          FractionBox["1", "32"]}], ",", 
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "3"], "\[Rule]", 
          FractionBox["1", "4"]}], ",", 
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "4"], "\[Rule]", 
          FractionBox["1", "4"]}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[DoubleStruckCapitalE]", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["\[DoubleStruckA]", "2"], ",", 
            SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
         RowBox[{"\[DoubleStruckCapitalH]", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["\[DoubleStruckA]", "3"], ",", 
            SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
         RowBox[{"\[CapitalOmega]", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["\[DoubleStruckA]", "1"], ",", 
            SubscriptBox["\[DoubleStruckA]", "2"], ",", 
            SubscriptBox["\[DoubleStruckA]", "3"], ",", 
            SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "1"], "\[Rule]", 
          RowBox[{
           FractionBox["3", "512"], " ", 
           RowBox[{"(", 
            RowBox[{"59", "+", 
             RowBox[{"5", " ", 
              SqrtBox["161"]}]}], ")"}]}]}], ",", 
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "2"], "\[Rule]", 
          FractionBox["1", "32"]}], ",", 
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "3"], "\[Rule]", 
          FractionBox["1", "4"]}], ",", 
         RowBox[{
          SubscriptBox["\[DoubleStruckA]", "4"], "\[Rule]", 
          RowBox[{
           FractionBox["1", "512"], " ", 
           RowBox[{"(", 
            RowBox[{"191", "-", 
             RowBox[{"15", " ", 
              SqrtBox["161"]}]}], ")"}]}]}]}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "T", ",", 
     FractionBox["1", "4"], ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "F", ",", 
     FractionBox["1", "4"], ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"F", ",", "T", ",", 
     FractionBox["1", "32"], ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"F", ",", "F", ",", 
     FractionBox["15", "32"], ",", 
     RowBox[{"1", "-", "d", "-", "e", "-", "f"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.808651714181447*^9, 3.808658888028491*^9, 3.80867112724452*^9, {
   3.808671437218666*^9, 3.808671449473483*^9}, 3.808671538363873*^9, 
   3.808673567104237*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"4fc59f1d-c863-42d3-8e2d-8e2f62a94dd5"]
}, Open  ]],

Cell[TextData[{
 "First, let\[CloseCurlyQuote]s verify that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["LR", 
    StyleBox["m", "Input",
     FontSlant->"Plain"]], TraditionalForm]],ExpressionUUID->
  "eaba4d48-0a01-4b9a-8cf5-9a9e1acea337"],
 "[\[DoubleStruckCapitalH],\[DoubleStruckCapitalE]] = 8. (Note that PrSAT \
indexes truth table rows in descending order, with FF indexed to 4 and TT \
indexed to 1 in this case. I follow the more common usage in philosophy when \
indexing them in the text.)"
}], "Text",
 CellChangeTimes->{{3.806930967582836*^9, 3.806930998942123*^9}, {
  3.8069310994625597`*^9, 3.806931102900342*^9}, {3.808658292282926*^9, 
  3.808658533277219*^9}, {3.808658876115775*^9, 
  3.808658882833273*^9}},ExpressionUUID->"591b1f5f-eb45-41e1-b00c-\
414e1ad28b39"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"PrSAT", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Pr", "[", 
       RowBox[{"\[DoubleStruckCapitalH]", "&&", "\[DoubleStruckCapitalE]"}], 
       "]"}], "\[Equal]", 
      FractionBox["1", "4"]}], ",", 
     RowBox[{
      RowBox[{"Pr", "[", 
       RowBox[{"\[DoubleStruckCapitalH]", "&&", 
        RowBox[{"\[Not]", "\[DoubleStruckCapitalE]"}]}], "]"}], "\[Equal]", 
      FractionBox["1", "4"]}], ",", 
     RowBox[{
      RowBox[{"Pr", "[", 
       RowBox[{
        RowBox[{"\[Not]", "\[DoubleStruckCapitalH]"}], "&&", 
        "\[DoubleStruckCapitalE]"}], "]"}], "\[Equal]", 
      FractionBox["1", "32"]}]}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.806931018736969*^9, 3.806931054226853*^9}, 
   3.80693108850354*^9},
 CellLabel->"In[75]:=",ExpressionUUID->"72722259-89d7-42fd-98d5-c5f20c93b264"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[DoubleStruckCapitalE]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[DoubleStruckA]", "2"], ",", 
        SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
     RowBox[{"\[DoubleStruckCapitalH]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[DoubleStruckA]", "3"], ",", 
        SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
     RowBox[{"\[CapitalOmega]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[DoubleStruckA]", "1"], ",", 
        SubscriptBox["\[DoubleStruckA]", "2"], ",", 
        SubscriptBox["\[DoubleStruckA]", "3"], ",", 
        SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "1"], "\[Rule]", 
      FractionBox["15", "32"]}], ",", 
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "2"], "\[Rule]", 
      FractionBox["1", "32"]}], ",", 
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "3"], "\[Rule]", 
      FractionBox["1", "4"]}], ",", 
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "4"], "\[Rule]", 
      FractionBox["1", "4"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.806931054889925*^9, 3.806931089144662*^9, 3.808651714209385*^9, 
   3.808658888053585*^9, 3.808671127276683*^9, {3.80867143724074*^9, 
   3.808671449495757*^9}, 3.808671538375812*^9, 3.8086735671272287`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"184a1de6-67b8-466b-a311-ac6b51bfdc86"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvaluateProbability", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"Pr", "[", 
      RowBox[{"\[DoubleStruckCapitalE]", "|", "\[DoubleStruckCapitalH]"}], 
      "]"}], 
     RowBox[{"Pr", "[", 
      RowBox[{"\[DoubleStruckCapitalE]", "|", 
       RowBox[{"\[Not]", "\[DoubleStruckCapitalH]"}]}], "]"}]], "\[Equal]", 
    "8"}], ",", "m"}], "]"}]], "Input",
 CellChangeTimes->{{3.80693100052*^9, 3.806931013380528*^9}, {
  3.806931062931313*^9, 3.806931077268405*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"c38007db-22cc-4087-b00e-2c7dd24f2603"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.806931077730246*^9, 3.806931090407734*^9}, 
   3.8086517142143993`*^9, 3.808658888058769*^9, 3.8086711272832613`*^9, {
   3.808671437246373*^9, 3.808671449501856*^9}, 3.8086715383968353`*^9, 
   3.808673567132874*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"e5de5d80-bfcd-4a16-82f4-ec3c15d250d6"]
}, Open  ]],

Cell[TextData[{
 "Now, we can ask: what is the closest probability function ",
 Cell[BoxData[
  SuperscriptBox["m", "*"]], "Input",
  CellChangeTimes->{{3.806923318674481*^9, 3.8069233813565598`*^9}, {
   3.806930658877268*^9, 3.8069307080003357`*^9}},ExpressionUUID->
  "e18fdd02-31db-4006-801d-3b7aa2e21028"],
 " to ",
 Cell[BoxData["m"], "Input",
  CellChangeTimes->{{3.806923318674481*^9, 3.8069233813565598`*^9}, {
   3.806930658877268*^9, 3.8069307080003357`*^9}},ExpressionUUID->
  "734fff58-164b-4416-8af1-d7154d8495ed"],
 " such that  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["LR", 
    StyleBox[
     SuperscriptBox[
      StyleBox["m",
       FontSlant->"Plain"], "*"], "Input"]], TraditionalForm]],ExpressionUUID->
  "0cddb0a6-ae1e-473a-8696-93f180e897b2"],
 "[\[Not]\[DoubleStruckCapitalH],\[DoubleStruckCapitalE]] = 8?  This is \
easily answered, as follows (here, it\[CloseCurlyQuote]s algebraically easier \
to use ",
 StyleBox["ManhattanDistance", "Input"],
 "):"
}], "Text",
 CellChangeTimes->{{3.806930744846546*^9, 3.8069307846012077`*^9}, {
  3.806931252008534*^9, 3.806931261613941*^9}, {3.806931458348023*^9, 
  3.80693146493093*^9}, {3.808651900621089*^9, 
  3.808651915552238*^9}},ExpressionUUID->"ec6f646f-586f-4f17-aa0c-\
ec335336bbee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Minimize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ManhattanDistance", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["1", "4"], ",", 
           FractionBox["1", "4"], ",", 
           FractionBox["1", "32"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "]"}], ",", 
       RowBox[{
        FractionBox["f", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"(", 
              RowBox[{"d", "+", "e"}], ")"}]}], ")"}], " ", "d"}], 
          RowBox[{"d", "+", "e"}]]], "\[Equal]", "8"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.8069303334164953`*^9, 3.806930397803754*^9}, {
  3.8069305082817717`*^9, 3.806930509622857*^9}, {3.806930811519793*^9, 
  3.806930818567218*^9}, {3.806931125309033*^9, 3.80693112782136*^9}, {
  3.806931206016165*^9, 3.806931215894412*^9}, {3.8069313008040857`*^9, 
  3.8069313028432713`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"4b94d22f-4745-474f-97ed-ff2c95e39169"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["3", "512"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "21"}], "+", 
      RowBox[{"5", " ", 
       SqrtBox["161"]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", 
      RowBox[{
       FractionBox["1", "512"], " ", 
       RowBox[{"(", 
        RowBox[{"191", "-", 
         RowBox[{"15", " ", 
          SqrtBox["161"]}]}], ")"}]}]}], ",", 
     RowBox[{"e", "\[Rule]", 
      FractionBox["1", "4"]}], ",", 
     RowBox[{"f", "\[Rule]", 
      FractionBox["1", "32"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8069303735241547`*^9, 3.806930399226769*^9}, 
   3.80693050999783*^9, {3.8069307957293386`*^9, 3.806930819186775*^9}, 
   3.806931128985512*^9, {3.806931207543138*^9, 3.8069312168396063`*^9}, 
   3.806931265333324*^9, 3.806931303826518*^9, 3.8086517150983057`*^9, 
   3.808658888679482*^9, 3.808671127941256*^9, {3.80867143787206*^9, 
   3.808671450117337*^9}, 3.808671539005102*^9, 3.808673567746827*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"2f7bf600-7fd2-438c-af5f-a21e1dd41de0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["m", "*"], "=", 
  RowBox[{"PrSAT", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Pr", "[", 
        RowBox[{"\[DoubleStruckCapitalH]", "&&", "\[DoubleStruckCapitalE]"}], 
        "]"}], "\[Equal]", "d"}], "//.", "\[VeryThinSpace]", 
      RowBox[{"sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
      ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Pr", "[", 
        RowBox[{"\[DoubleStruckCapitalH]", "&&", 
         RowBox[{"\[Not]", "\[DoubleStruckCapitalE]"}]}], "]"}], "\[Equal]", 
       "e"}], "//.", "\[VeryThinSpace]", 
      RowBox[{"sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}],
      ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Pr", "[", 
        RowBox[{
         RowBox[{"\[Not]", "\[DoubleStruckCapitalH]"}], "&&", 
         "\[DoubleStruckCapitalE]"}], "]"}], "\[Equal]", "f"}], "//.", 
      "\[VeryThinSpace]", 
      RowBox[{
      "sol", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
    "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.806931132858569*^9, 3.8069311758962708`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"1a632f52-7b10-40f9-8513-92a049225db4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[DoubleStruckCapitalE]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[DoubleStruckA]", "2"], ",", 
        SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
     RowBox[{"\[DoubleStruckCapitalH]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[DoubleStruckA]", "3"], ",", 
        SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}], ",", 
     RowBox[{"\[CapitalOmega]", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["\[DoubleStruckA]", "1"], ",", 
        SubscriptBox["\[DoubleStruckA]", "2"], ",", 
        SubscriptBox["\[DoubleStruckA]", "3"], ",", 
        SubscriptBox["\[DoubleStruckA]", "4"]}], "}"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "1"], "\[Rule]", 
      RowBox[{
       FractionBox["3", "512"], " ", 
       RowBox[{"(", 
        RowBox[{"59", "+", 
         RowBox[{"5", " ", 
          SqrtBox["161"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "2"], "\[Rule]", 
      FractionBox["1", "32"]}], ",", 
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "3"], "\[Rule]", 
      FractionBox["1", "4"]}], ",", 
     RowBox[{
      SubscriptBox["\[DoubleStruckA]", "4"], "\[Rule]", 
      RowBox[{
       FractionBox["1", "512"], " ", 
       RowBox[{"(", 
        RowBox[{"191", "-", 
         RowBox[{"15", " ", 
          SqrtBox["161"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8069311358789454`*^9, 3.806931177617709*^9, {3.8069312110038424`*^9, 
   3.806931218841009*^9}, 3.806931267233376*^9, 3.806931308718731*^9, 
   3.808651715199683*^9, 3.8086588887002983`*^9, 3.808671127960456*^9, {
   3.808671437891755*^9, 3.808671450136611*^9}, 3.808671539025043*^9, 
   3.808673567766831*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"6f300866-cc3b-4956-955a-c5aed25b65fc"]
}, Open  ]],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s verify that  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["LR", 
    StyleBox[
     SuperscriptBox[
      StyleBox["m",
       FontSlant->"Plain"], "*"], "Input"]], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "46633380-753e-4fba-92fe-a648c84a5a74"],
 "[\[Not]\[DoubleStruckCapitalH],\[DoubleStruckCapitalE]] = 8."
}], "Text",
 CellChangeTimes->{{3.8069314265022917`*^9, 
  3.806931468321142*^9}},ExpressionUUID->"7531a513-8b78-4c9e-b190-\
58ae84d57304"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EvaluateProbability", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"Pr", "[", 
      RowBox[{"\[DoubleStruckCapitalE]", "|", 
       RowBox[{"\[Not]", "\[DoubleStruckCapitalH]"}]}], "]"}], 
     RowBox[{"Pr", "[", 
      RowBox[{"\[DoubleStruckCapitalE]", "|", "\[DoubleStruckCapitalH]"}], 
      "]"}]], "\[Equal]", "8"}], ",", 
   SuperscriptBox["m", "*"]}], "]"}]], "Input",
 CellChangeTimes->{{3.806931275698086*^9, 3.8069312803573837`*^9}},
 CellLabel->"In[79]:=",ExpressionUUID->"66e134c4-3914-4d0d-a182-7dcfa3540215"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.806931280708036*^9, 3.806931310725814*^9, 3.8086517152056637`*^9, 
   3.808658888706661*^9, 3.808671127965468*^9, {3.8086714378975277`*^9, 
   3.808671450142367*^9}, 3.808671539030332*^9, 3.808673567772246*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"4262d071-aacd-4bc9-9c7f-744c0f838e58"]
}, Open  ]],

Cell[TextData[{
 "As you can see below, the closest such distribution ",
 Cell[BoxData[
  SuperscriptBox["m", "*"]], "Input",
  CellChangeTimes->{{3.806923318674481*^9, 3.8069233813565598`*^9}, {
   3.806930658877268*^9, 3.8069307080003357`*^9}},ExpressionUUID->
  "753d6c1c-1c5e-40ff-85ac-671ef8e4ab3b"],
 " is ~0.25 away from ",
 StyleBox["m", "Input"],
 " in Manhattan distance!"
}], "Text",
 CellChangeTimes->{{3.806930404305719*^9, 3.806930418742629*^9}, {
  3.8069305145931664`*^9, 3.8069305256608477`*^9}, {3.806930831368629*^9, 
  3.806930842947772*^9}, {3.806931225316629*^9, 3.806931227598659*^9}, {
  3.8069312848592243`*^9, 3.8069312858752193`*^9}, {3.808651956090254*^9, 
  3.808651956789365*^9}},ExpressionUUID->"d14cb049-0dc4-4a18-9ae8-\
38fb02c793d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "//", "N"}]], "Input",
 CellChangeTimes->{{3.806931233638979*^9, 3.806931234965911*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"109dec60-ecc4-48cd-b006-6ec31e28080a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.24868879513035705`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "\[Rule]", "0.001311204869642979`"}], ",", 
     RowBox[{"e", "\[Rule]", "0.25`"}], ",", 
     RowBox[{"f", "\[Rule]", "0.03125`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.806931240085636*^9, {3.806931287833695*^9, 3.806931312488758*^9}, 
   3.808651715228138*^9, 3.808658888726967*^9, 3.808671127983583*^9, {
   3.8086714379282*^9, 3.8086714501610937`*^9}, 3.8086715390499077`*^9, 
   3.808673567792144*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"ced722cd-0501-4624-8e66-836f31eb32b7"]
}, Open  ]],

Cell[TextData[{
 "We can write a function ",
 StyleBox["f", "Input"],
 " which takes the constraint ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["LR", 
    StyleBox[
     SuperscriptBox[
      StyleBox["m",
       FontSlant->"Plain"], "'"], "Input"]], TraditionalForm]],ExpressionUUID->
  "6868442d-f788-43e4-8711-da050df9d659"],
 "[\[DoubleStruckCapitalH],\[DoubleStruckCapitalE]] as an argument, and \
returns the distance of the closest ",
 Cell[BoxData[
  SuperscriptBox["m", "'"]], "Input",
  CellChangeTimes->{{3.806923318674481*^9, 3.8069233813565598`*^9}, {
   3.806930658877268*^9, 3.8069307080003357`*^9}},ExpressionUUID->
  "475b796f-9b4a-4543-8136-7829d8087627"],
 " to ",
 StyleBox["m", "Input"],
 ", satisfying this constraint."
}], "Text",
 CellChangeTimes->{{3.8069347510054913`*^9, 3.8069347808603773`*^9}, {
   3.8069348598501663`*^9, 3.806934945043137*^9}, {3.80693577107873*^9, 
   3.806935771186048*^9}, 3.808670843420021*^9, {3.808673541432181*^9, 
   3.808673545537184*^9}},ExpressionUUID->"9144c605-9d6e-4d6b-84db-\
f71e2b6ed4be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "l_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", "l", "]"}], "=", 
   RowBox[{
    RowBox[{"Minimize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ManhattanDistance", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            FractionBox["1", "4"], ",", 
            FractionBox["1", "4"], ",", 
            FractionBox["1", "32"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "]"}], ",", 
        RowBox[{
         FractionBox["f", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"(", 
               RowBox[{"d", "+", "e"}], ")"}]}], ")"}], " ", "d"}], 
           RowBox[{"d", "+", "e"}]]], "\[Equal]", 
         FractionBox["1", "l"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "]"}], 
    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}]], "Input",
 CellChangeTimes->{{3.8069349473447027`*^9, 3.806934949474585*^9}, {
  3.8069349914279413`*^9, 3.806935007922205*^9}, {3.8069351706695023`*^9, 
  3.806935172743046*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"8075aa67-21ab-42a9-b902-6ae77815a778"],

Cell["Sanity check on the known value:", "Text",
 CellChangeTimes->{{3.806935036039064*^9, 
  3.806935040695857*^9}},ExpressionUUID->"9c19b2f0-dc00-4c54-b25d-\
e5ab50a00850"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", 
   FractionBox["1", "8"], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8069350115515413`*^9, 3.806935030621278*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"222d4e78-dcdc-42a2-9baa-67521ea259d3"],

Cell[BoxData["0.24868879513035702`"], "Output",
 CellChangeTimes->{{3.806935013394226*^9, 3.806935032863462*^9}, 
   3.806935175253661*^9, 3.808651715817452*^9, 3.80865888875244*^9, 
   3.808671128012394*^9, {3.808671437936776*^9, 3.808671450169415*^9}, 
   3.8086715390746527`*^9, 3.808673567801179*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"bfd5d571-4681-4513-976b-8e5ddcf55270"]
}, Open  ]],

Cell[TextData[{
 "Plot of ",
 StyleBox["f", "Input"],
 " as l goes from 8 to ",
 Cell[BoxData[
  FractionBox["1", "8"]], "Input",
  CellChangeTimes->{{3.8069350115515413`*^9, 3.806935030621278*^9}},
  ExpressionUUID->"4c564613-c2c1-44eb-b730-6b7447dc4e5e"],
 ",  by increments of ",
 Cell[BoxData[
  FractionBox["1", "16"]], "Input",
  CellChangeTimes->{{3.8069350115515413`*^9, 3.806935030621278*^9}},
  ExpressionUUID->"460acead-c709-4357-b7c1-2c73742eb55d"],
 "."
}], "Text",
 CellChangeTimes->{{3.806935043711872*^9, 3.806935100519775*^9}, {
  3.806935333544702*^9, 
  3.8069353336203938`*^9}},ExpressionUUID->"a8b73f6c-15d7-434e-9e3c-\
83cec6315722"],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"l", ",", 
       RowBox[{"f", "[", "l", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "8", ",", 
       FractionBox["1", "8"], ",", 
       RowBox[{"-", 
        FractionBox["1", "16"]}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.806935165365637*^9, 3.806935214919077*^9}, {
  3.806935278643257*^9, 3.806935283335927*^9}, {3.806935323462792*^9, 
  3.8069353251391773`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"8285379b-7f99-4397-8cc6-7a762e4cf151"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"points", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"l", ",", 
        RowBox[{"{", 
         RowBox[{"l", ",", "0", ",", "8", ",", "0.5"}], "}"}]}], "]"}], ",", 
      "Automatic"}], "}"}]}], ",", " ", 
   RowBox[{"AxesLabel", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Likelihood", " ", "ratio"}], " ", ",", "Distance"}], "}"}]}]}],
   "]"}]], "Input",
 CellChangeTimes->{{3.806935457915633*^9, 3.806935476503819*^9}, {
  3.80693553628211*^9, 3.806935597523219*^9}, {3.808671371843603*^9, 
  3.808671528647964*^9}},
 CellLabel->"In[84]:=",ExpressionUUID->"0c4f8720-3245-458f-8d39-154140308e6b"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxNlHtQlFUYxldgZZdF2YVlwQV2F4vCRhktM0nzPOAY1JjipQQFJxSzyFFS
tFEw2V3RCFMBL6ngLU1M8UJ4DXUXb3QZXS8VmpZgiuNtEFEE1PrY79mZ3nmY
M795+P1z3j1f5KQZo6d4KRSKBdJf5ymPBYr/j8MMlY+XFZa+ws15Zmh94qRA
ZpjR/kVmdXZJoswKMxZq41WRC5Nkdpjg0nu9F+kaS9+E5IR1rb1iUuib8LTo
Qm7F+jT6Jujck04/AkHWVCmT6UfAlTW69cbeKfQjEGrVSfmYfgTSD23TrcrJ
pB+Os7roy5lN0+iHw6dVdyUhawb9cDj/DFBXP8uiH47iF9+RMpN+GMpj1Sfy
186iH4bmFZaR6uZs+mF4nqGednnkHPphiM9R34uq+py+ER35yaOM5rn0jfA7
NeFS4/J59I0odail5NI3Yn1dQVldwXz6PaBPjGqcoltAvweS3JNHvwfuTi1c
WR9mpS/xqIOm/DtkRygyn71rHX/MRj8UN/XVpbbVdvqhGHutcIc5eyH9ULzv
nnz6Idg3WVmTOGgR/RCkxQ3fZXlpMf0QGJI/tCoNX9IPQVF+74xITQF9A8Zv
VEr5ir4BE/YopRTSN8CpjMmyapbQNyAkLfvcsJCv6QfDUtKgfLXXUvrBcIW0
KOfHLaMfjL7uWU4/GP38j/f1P0526DGm8Q/TzJQi+nq09Btotj8kQw/nhYq2
9KJi+nq85p4S+kGonGp5JeISOS8Iryfa+yfaV9APQs7pi46/+q2kH4RRE4fO
7XaD7AhE2QDXJ95lq+gHYsNse6/mlNX0A+G0evt2D/+GfiBil14fuPQ62aGD
YYBvYMWeNfR1GFRuf7Pcvpa+Dvu9Z91zpK6jr8Ng95TS1+LM9Ppxk3uW0ddC
O+TJNXvAevpaiCZvKRvoayGfG/n/AYhU2SwqG1kRAOlxSy98E/vumFM1d0ND
MVnRHT3ds5l9NxhH3D46eD9Z0Q29W/vXzBz5LXt/1A+xdajukxX+iOp8fsVb
2GvwVlTtGNvgrew1ODex84WR8/xge/DB49gt37H3w8tzJknZxl6NaPeUs1fj
cXTqsppH5DwVZvlNHOH8ZTt7FXZ87x72vpB+7OO0JTvY+6I23lC5PH8n+66I
qbP1qbNVsO+KJTGHb20u3MVeiVuadtvRjbvZKxG6KF3KHvY+aA8tXeZsIyt8
sHZN5+xl7w3jljgpley9Eb17U/WiZnKeF1yHnfq2nT+w90L46c+kVLHvgoiL
cVL2se8Ck3v2s1dAZc5tcvoeYK/g/g+S/xXyvg+Rnwt5v4fJz4S8zx/JT4W8
v2pyh5D3dYTcLuT9HCO3iRz9roT6eQ7yEyF/f5zkViF9TFJq42vIj8Xb7g/E
cfIjId/nCXKLkO/vJPmhkO/rFLlZyPdTS34g5Pv4mdzE81ee90XlivwWm/YM
+a5IS/XJvXrSw7fF7CQkZ1z18C1x/kRG45EWD98UBVujztzWnCX/I5Zo1lXc
6enhBvF7Q+oLzlgPXxMN9rKfPk3y8BVxfvjQN+5+5OE6cWNYF8XQ+R6+KBKu
TK/KKvGwS9QeMTXM3u7hWoG/q4LGHPOwQ/Q50OFS/XZW/AcusA1z
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     RowBox[{"Likelihood", " ", "ratio"}], TraditionalForm], 
    FormBox["Distance", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{544.125, Automatic},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 8.}, {0, 0.24868879513035705`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{{{0., 
      FormBox["0.`", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1., 
      FormBox["1.`", TraditionalForm]}, {1.5, 
      FormBox["1.5`", TraditionalForm]}, {2., 
      FormBox["2.`", TraditionalForm]}, {2.5, 
      FormBox["2.5`", TraditionalForm]}, {3., 
      FormBox["3.`", TraditionalForm]}, {3.5, 
      FormBox["3.5`", TraditionalForm]}, {4., 
      FormBox["4.`", TraditionalForm]}, {4.5, 
      FormBox["4.5`", TraditionalForm]}, {5., 
      FormBox["5.`", TraditionalForm]}, {5.5, 
      FormBox["5.5`", TraditionalForm]}, {6., 
      FormBox["6.`", TraditionalForm]}, {6.5, 
      FormBox["6.5`", TraditionalForm]}, {7., 
      FormBox["7.`", TraditionalForm]}, {7.5, 
      FormBox["7.5`", TraditionalForm]}, {8., 
      FormBox["8.`", TraditionalForm]}}, Automatic}]], "Output",
 CellChangeTimes->{
  3.8069352947543573`*^9, 3.8069353680198917`*^9, 3.806935464544942*^9, {
   3.806935563780686*^9, 3.80693559779862*^9}, 3.808651788745297*^9, 
   3.808658888797667*^9, 3.808671128049592*^9, {3.808671437984744*^9, 
   3.808671450216591*^9}, 3.808671539127335*^9, 3.8086735678634377`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"ef48d4e2-f3fb-4bb4-9f86-293f84be3ef1"]
}, Open  ]],

Cell[TextData[{
 "As suggested, ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox[
    StyleBox["m",
     FontSlant->"Plain"], "'"], "Input"]],ExpressionUUID->
  "546a7c21-491a-4f2f-a912-9780c9458837"],
 " ",
 StyleBox["gets",
  FontSlant->"Italic"],
 " ",
 StyleBox["monotonically closer to",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  StyleBox["m", "Input",
   FontSlant->"Plain"]],ExpressionUUID->
  "381ba5d0-8cd4-4223-98f7-00490ef58fd6"],
 ", as ",
 Cell[BoxData[
  StyleBox[
   SuperscriptBox[
    StyleBox["m",
     FontSlant->"Plain"], "'"], "Input"]],ExpressionUUID->
  "ef08c432-bfa5-4646-a4ef-f06f19d69117"],
 "\[CloseCurlyQuote]s likelihood ratio approaches 8 (which is ",
 Cell[BoxData[
  StyleBox["m", "Input",
   FontSlant->"Plain"]],ExpressionUUID->
  "28ea1708-3095-4369-9b4a-23846df7f5f4"],
 "\[CloseCurlyQuote]s).  (There is a non-smoothness at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["LR", 
    StyleBox[
     SuperscriptBox[
      StyleBox["m",
       FontSlant->"Plain"], "'"], "Input"]], TraditionalForm]],ExpressionUUID->
  "27a34441-7ac2-49ea-a46f-6c2a4d305361"],
 "[\[DoubleStruckCapitalH],\[DoubleStruckCapitalE]] = 1, since that\
\[CloseCurlyQuote]s the shift from dis-confirmation to confirmation.)"
}], "Text",
 CellChangeTimes->{{3.80693536027861*^9, 3.806935424395327*^9}, {
   3.806935609314591*^9, 3.806935681941667*^9}, {3.8086706329198427`*^9, 
   3.8086706350904427`*^9}, 3.808670853411524*^9, {3.8086734705234337`*^9, 
   3.808673523757702*^9}},ExpressionUUID->"8891de6b-8e9c-4903-a9ef-\
9ff742a9e7c7"]
},
WindowSize->{1498, 863},
WindowMargins->{{68, Automatic}, {Automatic, 13}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification:>2. Inherited,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"cd1f62b9-21cd-46d6-94d0-8cee3f1200b7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 197, 3, 59, "Input",ExpressionUUID->"c51b649d-7383-4c70-81e8-943f214f9944"],
Cell[758, 25, 1084, 24, 114, "Text",ExpressionUUID->"a99b4e68-8620-4696-9173-f22fe6bbfd22"],
Cell[CellGroupData[{
Cell[1867, 53, 698, 19, 256, "Input",ExpressionUUID->"716b237e-d443-423a-a79b-a4a8f48d335c"],
Cell[2568, 74, 4004, 102, 296, "Output",ExpressionUUID->"4fc59f1d-c863-42d3-8e2d-8e2f62a94dd5"]
}, Open  ]],
Cell[6587, 179, 787, 17, 159, "Text",ExpressionUUID->"591b1f5f-eb45-41e1-b00c-414e1ad28b39"],
Cell[CellGroupData[{
Cell[7399, 200, 878, 23, 89, "Input",ExpressionUUID->"72722259-89d7-42fd-98d5-c5f20c93b264"],
Cell[8280, 225, 1590, 40, 111, "Output",ExpressionUUID->"184a1de6-67b8-466b-a311-ac6b51bfdc86"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9907, 270, 585, 14, 98, "Input",ExpressionUUID->"c38007db-22cc-4087-b00e-2c7dd24f2603"],
Cell[10495, 286, 350, 5, 89, "Output",ExpressionUUID->"e5de5d80-bfcd-4a16-82f4-ec3c15d250d6"]
}, Open  ]],
Cell[10860, 294, 1267, 31, 114, "Text",ExpressionUUID->"ec6f646f-586f-4f17-aa0c-ec335336bbee"],
Cell[CellGroupData[{
Cell[12152, 329, 1258, 33, 159, "Input",ExpressionUUID->"4b94d22f-4745-474f-97ed-ff2c95e39169"],
Cell[13413, 364, 1122, 29, 111, "Output",ExpressionUUID->"2f7bf600-7fd2-438c-af5f-a21e1dd41de0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14572, 398, 1218, 32, 101, "Input",ExpressionUUID->"1a632f52-7b10-40f9-8513-92a049225db4"],
Cell[15793, 432, 1973, 52, 166, "Output",ExpressionUUID->"6f300866-cc3b-4956-955a-c5aed25b65fc"]
}, Open  ]],
Cell[17781, 487, 520, 15, 69, "Text",ExpressionUUID->"7531a513-8b78-4c9e-b190-58ae84d57304"],
Cell[CellGroupData[{
Cell[18326, 506, 562, 13, 98, "Input",ExpressionUUID->"66e134c4-3914-4d0d-a182-7dcfa3540215"],
Cell[18891, 521, 345, 5, 89, "Output",ExpressionUUID->"4262d071-aacd-4bc9-9c7f-744c0f838e58"]
}, Open  ]],
Cell[19251, 529, 767, 16, 69, "Text",ExpressionUUID->"d14cb049-0dc4-4a18-9ae8-38fb02c793d5"],
Cell[CellGroupData[{
Cell[20043, 549, 197, 3, 59, "Input",ExpressionUUID->"109dec60-ecc4-48cd-b006-6ec31e28080a"],
Cell[20243, 554, 618, 13, 89, "Output",ExpressionUUID->"ced722cd-0501-4624-8e66-836f31eb32b7"]
}, Open  ]],
Cell[20876, 570, 1054, 27, 120, "Text",ExpressionUUID->"9144c605-9d6e-4d6b-84db-f71e2b6ed4be"],
Cell[21933, 599, 1279, 35, 218, "Input",ExpressionUUID->"8075aa67-21ab-42a9-b902-6ae77815a778"],
Cell[23215, 636, 174, 3, 69, "Text",ExpressionUUID->"9c19b2f0-dc00-4c54-b25d-e5ab50a00850"],
Cell[CellGroupData[{
Cell[23414, 643, 251, 5, 89, "Input",ExpressionUUID->"222d4e78-dcdc-42a2-9baa-67521ea259d3"],
Cell[23668, 650, 383, 5, 89, "Output",ExpressionUUID->"bfd5d571-4681-4513-976b-8e5ddcf55270"]
}, Open  ]],
Cell[24066, 658, 655, 18, 77, "Text",ExpressionUUID->"a8b73f6c-15d7-434e-9e3c-83cec6315722"],
Cell[24724, 678, 611, 16, 89, "Input",ExpressionUUID->"8285379b-7f99-4397-8cc6-7a762e4cf151"],
Cell[CellGroupData[{
Cell[25360, 698, 795, 20, 101, "Input",ExpressionUUID->"0c4f8720-3245-458f-8d39-154140308e6b"],
Cell[26158, 720, 4102, 88, 675, "Output",ExpressionUUID->"ef48d4e2-f3fb-4bb4-9f86-293f84be3ef1"]
}, Open  ]],
Cell[30275, 811, 1547, 47, 120, "Text",ExpressionUUID->"8891de6b-8e9c-4903-a9ef-9ff742a9e7c7"]
}
]
*)

